local metadata = {
"## Title: BuyMoreAnimals",
"## Author: Levis, All Rights Reserved",
"## Version: 1.0.0.2",
"## Date: 21.03.2024",
}
if g_currentModName ~= "FS22_zzz_BuyMoreAnimals" then
	print("Error: " .. g_currentModName .. " - File name mismatched")
	return
end
BuyMoreAnimals = {}
function BuyMoreAnimals:preInit()
    self.originalGetMaxNumAnimals = AnimalScreenBase.getMaxNumAnimals
    AnimalScreenBase.getMaxNumAnimals = function()
        return 2000
    end
    print("FS22_zzz_BuyMoreAnimals - Increase maximum purchase limit for animals by Levis - New limit: 2000")
end
function BuyMoreAnimals:onLoadMap(BuyMoreAnimals)
    BuyMoreAnimals:preInit()
end
function BuyMoreAnimals:onWriteStream(streamId, connection)
    streamWriteBool(streamId, true)
end
function BuyMoreAnimals:onReadStream(streamId, connection)
    local isModActive = streamReadBool(streamId)
    if isModActive then
        AnimalScreenBase.getMaxNumAnimals = function()
            return 2000
        end
    end
end
BaseMission.loadMap = Utils.prependedFunction(BaseMission.loadMap, BuyMoreAnimals.preInit)
