FieldLeaseAgreement = {}
local FieldLeaseAgreement_mt = Class(FieldLeaseAgreement, Object)
InitObjectClass(FieldLeaseAgreement, "FieldLeaseAgreement")

function FieldLeaseAgreement.new(isServer, isClient, customMt)
	local self = Object.new(isServer, isClient, customMt or FieldLeaseAgreement_mt)

    self.durationDirtyFlag = self:getNextDirtyFlag()

    return self
end

function FieldLeaseAgreement:updateDuration()
    self.duration = self.duration + 1
	self:raiseDirtyFlags(self.durationDirtyFlag)
end

function FieldLeaseAgreement:loadFromXMLFile(xmlFile, key)
    self.farmlandId = xmlFile:getInt(key.."#farmlandId")
    self.farmId = xmlFile:getInt(key.."#farmId")
    self.price = xmlFile:getInt(key.."#price")
    self.duration = xmlFile:getInt(key.."#duration")
    return true
end

function FieldLeaseAgreement:saveToXMLFile(xmlFile, key)
    xmlFile:setInt(key.."#farmlandId", self.farmlandId)
    xmlFile:setInt(key.."#farmId", self.farmId)
    xmlFile:setInt(key.."#price", self.price)
    xmlFile:setInt(key.."#duration", self.duration)
end

function FieldLeaseAgreement:readStream(streamId, connection)
    FieldLeaseAgreement:superClass().readStream(self, streamId, connection)

    self.farmlandId = streamReadInt32(streamId)
    self.farmId = streamReadInt32(streamId)
    self.price = streamReadInt32(streamId)
    self.duration = streamReadInt32(streamId)

    g_fieldLeasingManager.fieldLeaseAgreements[self.farmlandId] = self
end

function FieldLeaseAgreement:writeStream(streamId, connection)
    FieldLeaseAgreement:superClass().writeStream(self, streamId, connection)

    streamWriteInt32(streamId, self.farmlandId)
    streamWriteInt32(streamId, self.farmId)
    streamWriteInt32(streamId, self.price)
    streamWriteInt32(streamId, self.duration)
end

function FieldLeaseAgreement:readUpdateStream(streamId, timestamp, connection)
    FieldLeaseAgreement:superClass().readUpdateStream(self, streamId, timestamp, connection)

    if streamReadBool(streamId) then
		self.duration = streamReadInt32(streamId)
    end
end

function FieldLeaseAgreement:writeUpdateStream(streamId, connection, dirtyMask)
    FieldLeaseAgreement:superClass().writeUpdateStream(self, streamId, connection, dirtyMask)

	if streamWriteBool(streamId, bit32.band(dirtyMask, self.durationDirtyFlag) ~= 0) then
		streamWriteInt32(streamId, self.duration)
	end
end