--[[
ExtendedSugarBeetAndPotatoHarvesters

Specialization for extended sugar beet and potato harvesters

Author: 	Ifko[nator]
Date: 		09.11.2025
Version:	2.1

History:	v1.0 @20.12.2023 - initial implemation in FS 22
			--------------------------------------------------------------------------------
			v1.1 @29.07.2024 - fix if the premium dlc is not active
			--------------------------------------------------------------------------------
			v2.0 @12.12.2024 - convert to FS 25
			--------------------------------------------------------------------------------
			v2.1 @09.11.2025 - added support for onions from the highlands fishing expansion
]]

ExtendedSugarBeetAndPotatoHarvesters = {};
ExtendedSugarBeetAndPotatoHarvesters.currentModDirectory = "";
ExtendedSugarBeetAndPotatoHarvesters.fruitTypesToAdd = {};
ExtendedSugarBeetAndPotatoHarvesters.hasFinishedFirstRun = false;
ExtendedSugarBeetAndPotatoHarvesters.stopMod = false;

for _, mod in pairs(g_modManager.mods) do
	if mod.title == "Extended Sugar Beet And Potato Harvesters" or mod.title == "Erweiterte Zuckerrüben- Und Kartoffelernter" then		
		if g_modIsLoaded[mod.modName] then	
			ExtendedSugarBeetAndPotatoHarvesters.currentModDirectory = mod.modDir;

			break;
		end;
	end;
end;

if ExtendedSugarBeetAndPotatoHarvesters.currentModDirectory ~= "" then
	local modDesc = loadXMLFile("modDesc", ExtendedSugarBeetAndPotatoHarvesters.currentModDirectory .. "modDesc.xml");

	local fruitTypeNumber = 0;

	while true do
		local fruitTypeKey = "modDesc.fruitTypesToAdd.fruitTypeToAdd(" .. tostring(fruitTypeNumber) .. ")";

		if not hasXMLProperty(modDesc, fruitTypeKey) then
			break;
		end;

		local fruitTypeName = Utils.getNoNil((getXMLString(modDesc, fruitTypeKey .. "#name")):upper(), "");

		if fruitTypeName ~= "" then
			local fruitType = {};

			fruitType.name = fruitTypeName;
			fruitType.imageName = Utils.getNoNil(getXMLString(modDesc, fruitTypeKey .. "#imageName"), fruitType.name:lower());
			
			table.insert(ExtendedSugarBeetAndPotatoHarvesters.fruitTypesToAdd, fruitType);
		end;

		fruitTypeNumber = fruitTypeNumber + 1;
	end;

	delete(modDesc);
else
	print("Error from the ExtendedSugarBeetAndPotatoHarvesters.lua: Failed to find mod directory! This mod will be stopped now!");

	ExtendedSugarBeetAndPotatoHarvesters.stopMod = true;
end;

function ExtendedSugarBeetAndPotatoHarvesters.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(FillUnit, specializations) or SpecializationUtil.hasSpecialization(FruitPreparer, specializations);
end;

function ExtendedSugarBeetAndPotatoHarvesters.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onPreLoad", ExtendedSugarBeetAndPotatoHarvesters);
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", ExtendedSugarBeetAndPotatoHarvesters);
end;

function ExtendedSugarBeetAndPotatoHarvesters:onPreLoad(savegame)
	if ExtendedSugarBeetAndPotatoHarvesters.stopMod or self.xmlFile:hasProperty("vehicle.onionConfigurations") then
		return;
	end;

	if self.spec_cutter ~= nil then
		for _, fruitTypeToAdd in pairs(ExtendedSugarBeetAndPotatoHarvesters.fruitTypesToAdd) do
			if fruitTypeToAdd.name == "ONION" and FruitType[fruitTypeToAdd.name] ~= nil then
				setXMLString(self.xmlFile.handle, "vehicle.cutter#fillTypeConverter", fruitTypeToAdd.name .. "_HARVESTER");
				setXMLBool(self.xmlFile.handle, "vehicle.cutter#supportsPickupAI", true);
			end;
		end;
	end;
end;

function ExtendedSugarBeetAndPotatoHarvesters:onLoad(savegame)
	if ExtendedSugarBeetAndPotatoHarvesters.stopMod then
		return;
	end;
	
	local specFillUnit = self.spec_fillUnit;
	local specCutter = self.spec_cutter;
	local specSowingMachine = self.spec_sowingMachine;
	local specDischargeable = self.spec_dischargeable;
	local specFruitPreparer = self.spec_fruitPreparer;

	if specCutter ~= nil then
		local fruitTypes = "";
		
		for _, fruitTypeToAdd in pairs(ExtendedSugarBeetAndPotatoHarvesters.fruitTypesToAdd) do
			if fruitTypeToAdd.name == "ONION" and self.xmlFile:hasProperty("vehicle.onionConfigurations") then
				break;
			end;
			
			if FruitType[fruitTypeToAdd.name] ~= nil then
				local newFruitType = g_fruitTypeManager:getFruitTypeByName(fruitTypeToAdd.name);

				if newFruitType.preparedGrowthState == -1 then
					newFruitType.preparedGrowthState = 15;
				end;

				if fruitTypeToAdd.name == "BEETROOT" or fruitTypeToAdd.name == "CARROT" or fruitTypeToAdd.name == "PARSNIP" then
					newFruitType.minHarvestingGrowthState = 8;
    				newFruitType.maxHarvestingGrowthState = 8;
					newFruitType.preparedGrowthState = 8;
					
					newFruitType.harvestTransitions[8] = newFruitType.cutState;
					newFruitType.harvestReadyTransitions[8] = newFruitType.cutState;
					
					newFruitType.yieldScales[8] = 1;
					
					newFruitType.minPreparingGrowthState = 5;
					newFruitType.maxPreparingGrowthState = 5;
				end;
				
				if specCutter.fruitTypeIndices ~= nil then
					for _, fruitType in pairs(specCutter.fruitTypeIndices) do
						local fruitTypeName = g_fruitTypeManager:getFruitTypeByIndex(fruitType).name;
						
						if not fruitTypes:find(fruitTypeName) then
							if fruitTypes == "" then
								fruitTypes = fruitTypeName;
							else
								fruitTypes = fruitTypes .. ", " .. fruitTypeName;
							end;
						end;
					end;

					if fruitTypes:find("SUGARBEET") or fruitTypes:find("POTATO") and not fruitTypes:find(fruitTypeToAdd.name) then
						table.insert(specCutter.fruitTypeIndices, newFruitType.index);
					end;
				end;

				if specFruitPreparer ~= nil and specFruitPreparer.fruitTypes ~= nil then
					fruitTypes = "";

					for _, fruitType in pairs(specFruitPreparer.fruitTypes) do
						local fruitTypeName = g_fruitTypeManager:getFruitTypeByIndex(fruitType).name;
						
						if not fruitTypes:find(fruitTypeName) then
							if fruitTypes == "" then
								fruitTypes = fruitTypeName;
							else
								fruitTypes = fruitTypes .. ", " .. fruitTypeName;
							end;
						end;
						
						if not fruitTypes:find(fruitTypeToAdd.name) then
							table.insert(specFruitPreparer.fruitTypes, newFruitType.index);

							if self.setAIFruitRequirements ~= nil and newFruitType.hasAddedAIFruitRequirements == nil then
								if newFruitType.minPreparingGrowthState ~= -1 then
									self:setAIFruitRequirements(newFruitType.index, newFruitType.minPreparingGrowthState, newFruitType.maxPreparingGrowthState);
			
									local aiUsePreparedState = self.xmlFile:getValue("vehicle.fruitPreparer#aiUsePreparedState", true);

									if aiUsePreparedState then
										self:addAIFruitRequirement(newFruitType.index, newFruitType.preparedGrowthState, newFruitType.preparedGrowthState);
									end;
								else
									local minState = specFruitPreparer.allowsForageGrowthState and newFruitType.minForageGrowthState or newFruitType.minHarvestingGrowthState;

									self:addAIFruitRequirement(newFruitType.index, minState, newFruitType.maxHarvestingGrowthState);
								end;

								newFruitType.hasAddedAIFruitRequirements = true;
							end;
						end;
					end;
				end;
			end;	
		end;
	end;

	if specFillUnit ~= nil and specSowingMachine == nil then
		local fillUnitConfigurationId = Utils.getNoNil(self.configurations["fillUnit"], 1);
		local baseKey = ("vehicle.fillUnit.fillUnitConfigurations.fillUnitConfiguration(%d).fillUnits"):format(fillUnitConfigurationId - 1);
		
		local fillUnitNumber = 0;

    	while true do
			local fillUnitKey = ("%s.fillUnit(%d)"):format(baseKey, fillUnitNumber);

			if not self.xmlFile:hasProperty(fillUnitKey) then
    	        break;
			end;

			local fillTypes = getXMLString(self.xmlFile.handle, fillUnitKey .. "#fillTypes");
		
			if fillTypes ~= nil then
				for _, fillType in pairs(ExtendedSugarBeetAndPotatoHarvesters.fruitTypesToAdd) do
					if FillType[fillType.name] ~= nil then
						if specFillUnit.fillUnits[fillUnitNumber + 1].supportedFillTypes[FillType.SUGARBEET] 
							or specFillUnit.fillUnits[fillUnitNumber + 1].supportedFillTypes[FillType.POTATO]
							and not specFillUnit.fillUnits[fillUnitNumber + 1].supportedFillTypes[FillType[fillType.name]]
						then
							specFillUnit.fillUnits[fillUnitNumber + 1].supportedFillTypes[FillType[fillType.name]] = true;

							specFillUnit.hasAddedFruitTypes = true;
						end;
					end;
				end;
			end;

			fillUnitNumber = fillUnitNumber + 1;
		end;

		if specDischargeable ~= nil and specDischargeable.dischargeNodes ~= nil then
			for _, dischargeNode in ipairs(specDischargeable.dischargeNodes) do
				if dischargeNode.effects ~= nil and dischargeNode.effects ~= 0 then
					for _, effect in pairs(dischargeNode.effects) do
						if specFillUnit.hasAddedFruitTypes then
							if effect.emitCountScale ~= nil then
								effect.emitCountScale = 10;
							end;
						end;
					end;
				end;
			end;
		end;
	end;
end;

--## add the icons from the new fill types in the shop view
function ExtendedSugarBeetAndPotatoHarvesters:assignItemAttributeData(displayItem)
	if ExtendedSugarBeetAndPotatoHarvesters.stopMod then
		return;
	end;

	local vehicleXMLFile = loadXMLFile("vehicle", displayItem.storeItem.xmlFilename);
	local category = Utils.getNoNil(getXMLString(vehicleXMLFile, "vehicle.storeData.category"), "");
	local foundSowingMachine = Utils.getNoNil(getXMLString(vehicleXMLFile, "vehicle.sowingMachine.seedFruitTypes"), "false");

	if category:lower():find("beet") or category:lower():find("potato") or category == "augerWagons" then
		local function foundFillTypeInTable(fillTypeTable, fillType)
			for fillTypeNumber = 1, #fillTypeTable do
				if fillTypeTable[fillTypeNumber]:find(fillType) then
					return true;
				end;
			end;

			return false;
		end;

		for _, fillType in pairs(ExtendedSugarBeetAndPotatoHarvesters.fruitTypesToAdd) do
			if FillType[fillType.name] ~= nil then
				local foundFillType = foundFillTypeInTable(displayItem.fillTypeIconFilenames, fillType.imageName);

				if foundSowingMachine == "false" and not foundFillType and (foundFillTypeInTable(displayItem.fillTypeIconFilenames, "sugarBeet") or foundFillTypeInTable(displayItem.fillTypeIconFilenames, "potato")) then
					table.insert(displayItem.fillTypeIconFilenames, "dataS/menu/hud/fillTypes/hud_fill_" .. fillType.imageName .. ".png");
				end;
			end;
		end;
	end;

	delete(vehicleXMLFile);
end;

--## MaterialUtilFix
function ExtendedSugarBeetAndPotatoHarvesters.validateMaterialAttributes(node, superFunc, sourceFuncName)
	local fillTypeStr = getUserAttribute(node, "fillType");
    
	if fillTypeStr == nil then
        Logging.i3dWarning(node, "Missing 'fillType' user attribute for %q", sourceFuncName);
		
        return false;
    end;
	
    local fillTypeIndex = g_fillTypeManager:getFillTypeIndexByName(fillTypeStr);
	
    if fillTypeIndex == nil then
        --Logging.i3dWarning(node, "Unknown fillType %q in user attribute 'fillType' for %q", fillTypeStr, sourceFuncName);
		
        return false;
    end;
	
    local materialTypeName = getUserAttribute(node, "materialType");
	
    if materialTypeName == nil then
        Logging.i3dWarning(node, "Missing 'materialType' user attribute for %q", sourceFuncName);
		
        return false;
    end;
	
    local materialType = g_materialManager:getMaterialTypeByName(materialTypeName);
	
    if materialType == nil then
        Logging.i3dWarning(node, "Unknown materialType %q for %q", materialTypeName, sourceFuncName);
		
        return false;
    end;
	
    local materialIndex = Utils.getNoNil(tonumber(getUserAttribute(node, "materialIndex")), 1);
    
    if materialIndex == nil then
        Logging.i3dWarning(node, "Invalid materialIndex %q for %q", matIdStr, sourceFuncName);
		
        return false;
    end;
	
    return true, fillTypeIndex, materialType, materialIndex;
end;

if not ExtendedSugarBeetAndPotatoHarvesters.stopMod then 
	ShopItemsFrame.assignItemAttributeData = Utils.prependedFunction(ShopItemsFrame.assignItemAttributeData, ExtendedSugarBeetAndPotatoHarvesters.assignItemAttributeData);
	MaterialUtil.validateMaterialAttributes = Utils.overwrittenFunction(MaterialUtil.validateMaterialAttributes, ExtendedSugarBeetAndPotatoHarvesters.validateMaterialAttributes);
end;