--[[
	SowingMachineRollerReadyEvent.lua
	
	Autor: 		Ifko[nator]
	Datum: 		29.06.2025
	Version: 	2.0
	
	Changelog:	v1.0 @24.12.2021 - initial implementation in FS 22
				----------------------------------------------------------
				v2.0 @29.06.2025 - convert to FS 25
]]

SowingMachineRollerReadyEvent = {};
SowingMachineRollerReadyEvent_mt = Class(SowingMachineRollerReadyEvent, Event);

InitEventClass(SowingMachineRollerReadyEvent, "SowingMachineRollerReadyEvent");

function SowingMachineRollerReadyEvent.emptyNew()
	local self = Event.new(SowingMachineRollerReadyEvent_mt);
	
    self.className = "SowingMachineRollerReadyEvent";
	
	return self;
end;

function SowingMachineRollerReadyEvent.new(sowingMachine, allowRollerSowingMachine)
	local self = SowingMachineRollerReadyEvent.emptyNew();
	
    self.sowingMachine = sowingMachine;
	self.allowRollerSowingMachine = allowRollerSowingMachine;
	
	return self;
end;

function SowingMachineRollerReadyEvent:readStream(streamId, connection)
	self.sowingMachine = NetworkUtil.readNodeObject(streamId);
	
	self.allowRollerSowingMachine = streamReadBool(streamId);
	
    self:run(connection);
end;

function SowingMachineRollerReadyEvent:writeStream(streamId, connection)
	NetworkUtil.writeNodeObject(streamId, self.sowingMachine);

    streamWriteBool(streamId, self.allowRollerSowingMachine);
end;

function SowingMachineRollerReadyEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(self, nil, connection, self.sowingMachine);
	end;
	
	if self.sowingMachine ~= nil then
		self.sowingMachine:setAllowRollerSowingMachine(self.allowRollerSowingMachine, true);
	end;
end;

function SowingMachineRollerReadyEvent.sendEvent(sowingMachine, allowRollerSowingMachine, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SowingMachineRollerReadyEvent.new(sowingMachine, allowRollerSowingMachine), nil, nil, sowingMachine);
		else
			g_client:getServerConnection():sendEvent(SowingMachineRollerReadyEvent.new(sowingMachine, allowRollerSowingMachine));
		end;
	end;
end;